/*
 * Decompiled with CFR 0.152.
 */
package updateConsole.function;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class HashMapFile
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    String pathname;

    public HashMapFile(String filePath) {
        this.pathname = filePath;
        this.load();
    }

    public void commit() {
        Properties properties = new Properties();
        for (Map.Entry entry : this.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        try {
            properties.store(new FileOutputStream(this.pathname), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getSize() {
        return this.size();
    }

    public void load() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this.pathname));
            for (String key : properties.stringPropertyNames()) {
                this.put(key, properties.get(key).toString());
            }
        }
        catch (FileNotFoundException e) {
            this.put("mail", "");
            this.commit();
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void putString(String key, String value) {
        this.put(key, value);
    }

    public void putInt(String key, int value) {
        this.put(key, "" + value);
    }

    public int getInt(String key, int defaultValue) {
        for (Map.Entry m : this.entrySet()) {
            if (!((String)m.getKey()).equals(key)) continue;
            String value = (String)this.get(key);
            int intValue = Integer.valueOf(value);
            return intValue;
        }
        return defaultValue;
    }

    public String getString(String key, String defaultValue) {
        for (Map.Entry m : this.entrySet()) {
            if (!((String)m.getKey()).equals(key)) continue;
            return (String)this.get(key);
        }
        return defaultValue;
    }
}

