/*
 * Decompiled with CFR 0.152.
 */
package updateConsole.function;

import org.json.JSONObject;
import updateConsole.function.KutaiAes;

public class PacketStream {
    public static final int RECV_BUFFER_MAX = 65536;
    byte[] recvBuffer = new byte[65536];
    byte[] tmpBuffer;
    byte[] transBuffer;
    public byte[] recvData = new byte[65536];
    public int int_org;
    public int int_end;
    KutaiAes mKutaiAes;

    public PacketStream() {
        this.tmpBuffer = new byte[65536];
        this.mKutaiAes = new KutaiAes();
        this.clear();
    }

    public void clear() {
        this.int_org = 0;
        this.int_end = 0;
    }

    public int length() {
        if (this.int_end > this.int_org) {
            return this.int_end - this.int_org;
        }
        return 65536 - this.int_org + this.int_end;
    }

    public void insert(byte[] bytes, int len) {
        int i = 0;
        while (len > 0) {
            this.recvBuffer[this.int_end++] = bytes[i++];
            if (this.int_end >= 65536) {
                this.int_end = 0;
            }
            --len;
        }
    }

    public String checkPacket() {
        int len = this.length();
        int org = this.int_org;
        int i = 0;
        while (i < len) {
            this.tmpBuffer[i] = this.recvBuffer[org++];
            if (org >= 65536) {
                org = 0;
            }
            ++i;
        }
        KutaiAes.BufferDecodeInfo mDecodInfo = this.mKutaiAes.ManagerServerWithDecode(this.tmpBuffer, len, this.recvData);
        if (mDecodInfo.bufferDecodeLength > 0) {
            this.int_org += mDecodInfo.bufferDecodeIndex;
            if (this.int_org >= 65536) {
                this.int_org -= 65536;
            }
            int index = 0;
            index = 0;
            len = this.recvData[index++] & 0xFF;
            String str_json = new String(this.recvData, index, len |= (this.recvData[index++] & 0xFF) << 8);
            index += len;
            len = mDecodInfo.bufferDecodeLength - index;
            int i2 = 0;
            while (i2 < len) {
                this.recvData[i2] = this.recvData[index++];
                ++i2;
            }
            return str_json;
        }
        return "";
    }

    public int writePacketData(JSONObject json, byte[] datas, int dataLen, byte[] transBuffer) {
        byte[] bytesJson = json.toString().getBytes();
        int jsonLen = bytesJson.length;
        int index = 0;
        this.tmpBuffer[index++] = (byte)(jsonLen & 0xFF);
        this.tmpBuffer[index++] = (byte)(jsonLen >> 8 & 0xFF);
        int i = 0;
        while (i < jsonLen) {
            this.tmpBuffer[index++] = bytesJson[i];
            ++i;
        }
        this.tmpBuffer[index++] = (byte)(dataLen & 0xFF);
        this.tmpBuffer[index++] = (byte)(dataLen >> 8 & 0xFF);
        i = 0;
        while (i < dataLen) {
            this.tmpBuffer[index++] = datas[i];
            ++i;
        }
        int len = this.mKutaiAes.ManagerServerWithEncode(this.tmpBuffer, index, transBuffer);
        return len;
    }

    public int writePacket(JSONObject json, byte[] transBuffer) {
        byte[] bytesJson = json.toString().getBytes();
        int jsonLen = bytesJson.length;
        int index = 0;
        this.tmpBuffer[index++] = (byte)(jsonLen & 0xFF);
        this.tmpBuffer[index++] = (byte)(jsonLen >> 8 & 0xFF);
        int i = 0;
        while (i < jsonLen) {
            this.tmpBuffer[index++] = bytesJson[i];
            ++i;
        }
        int len = this.mKutaiAes.ManagerServerWithEncode(this.tmpBuffer, index, transBuffer);
        return len;
    }
}

