/*
 * Decompiled with CFR 0.152.
 */
package updateConsole;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;
import updateConsole.function.CRC16;
import updateConsole.function.PacketStream;

public class UpdateMain {
    static final boolean CONFIG_DEBUG = true;
    public static boolean fDebugPort = false;
    public static final int TCPIP_CLIENT_MAX = 800;
    public static final int ETHERNET_DISCONNECT = -1;
    public static final int ETHERNET_DEVICE_NOT_FOUND = -2;
    public static final int ETHERNET_SERVER_TIMEOUT = -3;
    public static final int ETHERNET_SERVER_DISCONNECT = -4;
    public static final int ETHERNET_SERVER_UNBIND = -5;
    public static final int ETHERNET_REPEAT_SIGN = -6;
    public static final int ETHERNET_DEVICE_OFFLINE_RECONNECT = -7;
    public static final int ETHERNET_SERVER_AUTHORITY_DENIED = -8;
    public static final int ETHERNET_GET_DATA = 1;
    public static final int ETHERNET_OPEN_FILE = 2;
    public static final int ETHERNET_EXIT = 3;
    public static final int ETHERNET_NORMAL = 0;
    private static final int NET_STATE_LOGIN = 3;
    private static final int NET_STATE_IDE = 1;
    private static final int NET_STATE_NONE = 0;
    private static final int NET_STATE_GET_INFO = 2;
    private static final int NET_STATE_DOWNLOAD_FILE_START = 4;
    private static final int NET_STATE_SERVER_LIST = 5;
    private static final int INFO_BLOCK_MAX = 1024;
    private static final int DOWNLOAD_BLOCK_MAX = 2048;
    public static final String SERVER_TABLE_0 = "updatea.kutai.net";
    public static final String SERVER_TABLE_1 = "updateb.kutai.net";
    Socket client;
    InputStream ins = null;
    OutputStream outs = null;
    PacketStream mPackStream = new PacketStream();
    byte[] writeBuffer = new byte[65536];
    boolean isConnect = false;
    byte[] bytesRead = new byte[64];
    String uuid = "";
    int fileIndex;
    int fileSize;
    int deviceType;
    int deviceNum;
    String strMAC;
    String strPacketName = "";
    String versionCode = "0";
    String strAppName = "";
    String strLanguage = "";
    String _appName;
    IRequest mIrequest;
    int intTransClock;
    int timeoutCount = 0;
    int net_state = 2;
    ByteArrayOutputStream baos = null;
    JSONArray jArrayInfo;

    public static void main(String[] args) {
        int stateSocket = 0;
        UpdateMain upMain = new UpdateMain(new IRequest(){

            @Override
            public void personPrintf(int n) {
            }

            @Override
            public void message(String s) {
            }
        }, true);
        if (args.length > 0) {
            int i = args.length;
            upMain.strPacketName = args[0];
            upMain.versionCode = args[1];
        }
        Thread t = Thread.currentThread();
        boolean fRun = true;
        boolean SystemRun = true;
        long tTick = 0L;
        while (SystemRun) {
            if (fRun) {
                if (upMain.isConnect) {
                    stateSocket = upMain.StateSocket();
                    switch (stateSocket) {
                        case -1: {
                            break;
                        }
                        case 2: {
                            fRun = false;
                            upMain.closeSocket();
                            tTick = System.currentTimeMillis();
                            break;
                        }
                        case 3: {
                            fRun = false;
                            upMain.closeSocket();
                            tTick = System.currentTimeMillis();
                        }
                    }
                } else {
                    upMain.isConnect = upMain.ConnectService();
                }
            } else if (System.currentTimeMillis() - tTick > 1000L) {
                try {
                    Process proc = Runtime.getRuntime().exec(String.valueOf(upMain._appName) + ".exe");
                    SystemRun = false;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public UpdateMain(IRequest mIrequest, boolean fDebug) {
        fDebugPort = fDebug;
        this.mIrequest = mIrequest;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            Random rand = new Random();
            rand.nextBytes(mac);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < mac.length) {
                sb.append(String.format("%s%02X", i > 0 ? "-" : "", mac[i]));
                ++i;
            }
            this.strMAC = sb.toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public int StateSocket() {
        int retValue = 0;
        if (this.isConnect) {
            try {
                int insLen = this.ins.available();
                if (insLen > 0) {
                    do {
                        insLen = this.ins.read(this.bytesRead);
                        this.mPackStream.insert(this.bytesRead, insLen);
                    } while (insLen == this.bytesRead.length);
                    String str_json = this.mPackStream.checkPacket();
                    if (str_json.length() > 0) {
                        System.out.printf("1:%s\n", str_json);
                        JSONObject json = new JSONObject(str_json);
                        String cmd = json.getString("cmd");
                        if (cmd.equals("Login_scuessful")) {
                            System.out.println("JSON_KEY_CMD_LOGIN_SCUESSFUL");
                            this.uuid = json.getString("UUID");
                            this.net_state = 5;
                        } else if (cmd.equals("Get_info")) {
                            System.out.println("JSON_KEY_CMD_GET_INFO");
                            this.timeoutCount = 0;
                            this.intTransClock = 2000;
                            if (this.GetInfo(json) == 0) {
                                this.net_state = 0;
                                System.out.println("get app file:" + this.strPacketName);
                                if (this.jArrayInfo.length() > 0) {
                                    int i = 0;
                                    while (i < this.jArrayInfo.length()) {
                                        JSONObject jsonsub = this.jArrayInfo.getJSONObject(i);
                                        if (this.strPacketName.equals(jsonsub.getString("packetName"))) {
                                            long _lOldVersionCode;
                                            String _versionCode = jsonsub.getString("VersionCode");
                                            long _lVersionCode = Long.valueOf(_versionCode);
                                            if (_lVersionCode > (_lOldVersionCode = Long.valueOf(this.versionCode).longValue())) {
                                                this.net_state = 4;
                                                this.deviceType = jsonsub.getInt("deviceType");
                                                this.deviceNum = jsonsub.getInt("deviceNumber");
                                                this.intTransClock = 500;
                                                this.fileIndex = 0;
                                                this.mIrequest.message("Downloading file");
                                                System.out.println("MSG:Downloading file");
                                            } else {
                                                this.mIrequest.message("exit");
                                            }
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                            }
                        } else if (cmd.equals("Download_data")) {
                            this.timeoutCount = 0;
                            this.intTransClock = 2000;
                            if (this.DownloadFile(json) == 0) {
                                this.net_state = 1;
                                retValue = 2;
                                this.mIrequest.personPrintf(100);
                                this.mIrequest.message("Open " + this._appName);
                            }
                        } else if (cmd.equals("Get_server_list")) {
                            JSONArray jsonArrayServerList = json.getJSONArray("Get_server_list");
                            System.out.println("jsonArrayServerList:" + jsonArrayServerList.toString());
                            this.net_state = 2;
                            this.timeoutCount = 0;
                            this.intTransClock = 50;
                        }
                    }
                }
                if (++this.timeoutCount % (this.intTransClock / 10) == 0) {
                    switch (this.net_state) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 5: {
                            JSONObject jsonSL = new JSONObject();
                            jsonSL.put("UUID", this.uuid);
                            jsonSL.put("cmd", "Get_server_list");
                            this.WriteSocket(jsonSL, null, 0);
                            break;
                        }
                        case 2: {
                            JSONObject jsonInfo = new JSONObject();
                            jsonInfo.put("UUID", this.uuid);
                            jsonInfo.put("cmd", "Get_info");
                            jsonInfo.put("Block", 1024);
                            this.fileIndex = 0;
                            jsonInfo.put("Index", this.fileIndex);
                            this.WriteSocket(jsonInfo, null, 0);
                            break;
                        }
                        case 3: {
                            System.out.println("NET_STATE_LOGIN");
                            JSONObject jsonlogin = new JSONObject();
                            jsonlogin.put("cmd", "Login_table");
                            jsonlogin.put("MAC", this.strMAC);
                            this.WriteSocket(jsonlogin, null, 0);
                            break;
                        }
                        case 4: {
                            JSONObject jsonDownload = new JSONObject();
                            jsonDownload.put("UUID", this.uuid);
                            jsonDownload.put("cmd", "Download_data");
                            jsonDownload.put("DeviceType", this.deviceType);
                            jsonDownload.put("DeviceNumber", this.deviceNum);
                            jsonDownload.put("Block", 2048);
                            jsonDownload.put("Index", this.fileIndex);
                            this.WriteSocket(jsonDownload, null, 0);
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            retValue = -1;
        }
        return retValue;
    }

    public boolean ConnectService() {
        boolean isConnect = false;
        String serverAddress = SERVER_TABLE_0;
        int serverport = fDebugPort ? 1235 : 1234;
        this.client = new Socket();
        InetSocketAddress server_isa = new InetSocketAddress(serverAddress, serverport);
        try {
            this.client.connect(server_isa, 5000);
            if (this.client.isConnected()) {
                isConnect = true;
                System.out.println("connected:" + serverAddress);
                this.ins = this.client.getInputStream();
                this.outs = this.client.getOutputStream();
                this.intTransClock = 1000;
                this.net_state = 3;
            } else {
                System.out.println("unconnect:" + serverAddress);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isConnect;
    }

    void WriteSocket(JSONObject json, byte[] data, int dataLen) {
        final int len = dataLen == 0 ? this.mPackStream.writePacket(json, this.writeBuffer) : this.mPackStream.writePacketData(json, data, dataLen, this.writeBuffer);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateMain.this.outs.write(UpdateMain.this.writeBuffer, 0, len);
                    UpdateMain.this.outs.flush();
                }
                catch (IOException e) {
                    try {
                        UpdateMain.this.client.close();
                        UpdateMain.this.client = null;
                        UpdateMain.this.isConnect = false;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        }).start();
    }

    int GetInfo(JSONObject json) {
        block5: {
            block6: {
                this.fileSize = json.getInt("FileSize");
                int index = json.getInt("Index");
                if (index == 0) {
                    if (this.baos != null) {
                        this.baos.close();
                    }
                    this.baos = null;
                    this.baos = new ByteArrayOutputStream();
                    this.fileIndex = 0;
                }
                if (this.fileSize <= 0) break block5;
                index = 0;
                int len = this.mPackStream.recvData[index++] & 0xFF;
                this.baos.write(this.mPackStream.recvData, index, len |= (this.mPackStream.recvData[index++] & 0xFF) << 8);
                this.fileIndex += len;
                if (this.fileIndex < this.fileSize) break block6;
                byte[] filebytes = this.baos.toByteArray();
                this.jArrayInfo = new JSONArray(new String(filebytes));
                this.baos.close();
                return 0;
            }
            try {
                JSONObject jsonInfo = new JSONObject();
                jsonInfo.put("UUID", this.uuid);
                jsonInfo.put("cmd", "Get_info");
                jsonInfo.put("Index", this.fileIndex);
                jsonInfo.put("Block", 1024);
                this.WriteSocket(jsonInfo, null, 0);
                return 1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    int DownloadFile(JSONObject jsondown) {
        block10: {
            block11: {
                int _devType = 0;
                int _devNum = 0;
                int index = 0;
                _devType = jsondown.getInt("DeviceType");
                _devNum = jsondown.getInt("DeviceNumber");
                index = jsondown.getInt("Index");
                if (_devNum == this.deviceNum && _devType == this.deviceType && index == 0) {
                    if (this.baos != null) {
                        this.baos.close();
                    }
                    this.baos = null;
                    this.baos = new ByteArrayOutputStream();
                    this.fileIndex = 0;
                    this.fileSize = jsondown.getInt("FileSize");
                }
                if (this.fileSize <= 0) break block10;
                index = 0;
                int len = this.mPackStream.recvData[index++] & 0xFF;
                this.baos.write(this.mPackStream.recvData, index, len |= (this.mPackStream.recvData[index++] & 0xFF) << 8);
                this.fileIndex += len;
                if (this.fileIndex < this.fileSize) break block11;
                byte[] filebytes = this.baos.toByteArray();
                index = 0;
                len = filebytes[index++] & 0xFF;
                JSONObject jsonFile = new JSONObject(new String(filebytes, index, len |= (filebytes[index++] & 0xFF) << 8));
                this._appName = jsonFile.getString("AppName");
                String _packetName = jsonFile.getString("packetName");
                _devType = jsonFile.getInt("DeviceType");
                _devNum = jsonFile.getInt("DeviceNumber");
                int _fileSize = jsonFile.getInt("FileSize");
                int crc16 = jsonFile.getInt("CRC");
                if (_devNum == this.deviceNum && _devType == this.deviceType) {
                    int crcTmp = CRC16.doCRC16(filebytes, index += len, _fileSize);
                    if (crc16 == crcTmp) {
                        String path = System.getProperty("user.dir");
                        File recordFile = new File(String.valueOf(path) + File.separator + this._appName + "." + "exe");
                        FileOutputStream out = new FileOutputStream(recordFile);
                        out.write(filebytes, index, _fileSize);
                        out.close();
                    } else {
                        System.out.println("CRC Error");
                    }
                } else {
                    System.out.println("DeviceType:" + this.deviceType + ",DeviceNum:" + this.deviceNum + ",Error DeviceType:" + _devType + ",DeviceNum:" + _devNum);
                }
                this.baos.close();
                return 0;
            }
            JSONObject jsonDownload = new JSONObject();
            jsonDownload.put("UUID", this.uuid);
            jsonDownload.put("cmd", "Download_data");
            jsonDownload.put("Index", this.fileIndex);
            jsonDownload.put("DeviceType", this.deviceType);
            jsonDownload.put("DeviceNumber", this.deviceNum);
            jsonDownload.put("Block", 2048);
            this.WriteSocket(jsonDownload, null, 0);
            this.mIrequest.personPrintf(this.fileIndex / (this.fileSize / 100));
            return 1;
        }
        try {
            System.out.println("Error FileSize is zero");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void closeSocket() {
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface IRequest {
        public void personPrintf(int var1);

        public void message(String var1);
    }
}

